/**
 * @namespace 共通処理
 */
var neo = {};

/**
 * @namespace 共通: 言語別リソース
 */
neo.Resource = {
    code : "ja_JP",
    codeCkeditor: "ja"
};

/**
 * 各種HTTPエラー
 */
neo.Resource.ajax = {
    "400_errorMessage" : "W:この処理は完了しているか手順を踏まえていない可能性があります。 作業を中断し、最初からやり直してください。",
    "403_errorMessage" : "W:要求された処理にアクセスできません。<br/>権限の変更が発生したかセッションが切れた可能性があります。作業を中断し、最初からやり直してください。",
    "404_errorMessage" : "URLが間違っている可能性があります。",
    "408_errorMessage" : "W:データベースサーバーが混み合っています。しばらく待ってから再度実行してください。",
    "409_errorMessage" : "データベースが停止している、または作業領域にアクセス権がない等、サーバーで異常が発生しました。システム管理者にご連絡ください。",
    "500_errorMessage" : "サーバーで異常が発生しました。システム管理者にご連絡ください。",
    "503_errorMessage" : "W:サーバーが混み合っています。しばらく待ってから再度実行してください。",
    "504_errorMessage" : "サーバーでタイムアウトが発生しました。",
    "errorMessage" : "サーバーが停止しているか、ネットワークが込み合っている可能性があります。"
};

/**
 * 日付の書式
 */
neo.Resource.dateTime = {
    // 短い月の名前
    "shortMonthes": ["1月", "2月", "3月", "4月", "5月", "6月", "7月", "8月", "9月", "10月", "11月", "12月"],
    // 長い月の名前
    "longMonthes": ["1月","2月","3月","4月","5月","6月","7月","8月","9月","10月","11月","12月"],
    // 短い週の名前(日曜日から)
    "shortWeeks": ["日","月","火","水","木","金","土"],
    // 長い週の名前(日曜日から)
    "longWeeks": ["日曜日","月曜日","火曜日","水曜日","木曜日","金曜日","土曜日"],
    // 午前/午後
    "periods": ["午前","午後"],
    // 経過時間
    "passedTime": {"second": "_秒前", "minute": "_分前", "hour": "_時間前", "day": "_日前", "month": "_ヶ月前", "year": "_年前"},
    "passedShortTime": {"second": "_秒", "minute": "_分", "hour": "_時間", "day": "_日", "month": "_ヶ月", "year": "_年"}
};

/**
 * ダイアログ文言
 */
neo.Resource.dialog = {
    "closeLabel": "閉じる", // タイトルバーの×ボタン
    "alertTitle": "警告",
    "confirmTitle": "確認",
    "alertButtonLabel": "閉じる", // メッセージ系ダイアログのボタン
    "confirmYesButtonLabel": "はい", // 確認ダイアログの肯定ボタン
    "confirmNoButtonLabel": "いいえ", // 確認ダイアログの否定ボタン
    "actionOkButtonLabel": "OK", // 選択/設定ダイアログの肯定ボタン
    "actionCancelButtonLabel": "キャンセル" // 選択/設定ダイアログの否定ボタン
};